﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR
{
    public partial class Referral : EfrBasePage
    {
        protected readonly string ReferralsPage = "referrals.aspx?statusId=";
        #region Constants
        #endregion
        
        private const string DodFragmentMessageMatch = "This patient HAS a matching entry in the DoD fragment data extract file.";
        private const string DodFragmentMessageNotMatch = "This patient DOES NOT HAVE a matching entry in the DoD fragment data extract file.";
        private const string DodFragmentDateMessage = "DoD Fragment Data Received: ";
        private bool isOriginal = false;

        private int referralId = 0;
        int patientIdFromQueryString = 0;

        VIRP.EFR.BO.REFERRAL_EFR_COMPLETE rc;

        public Referral()
        {
        }

        protected override void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                // Determine if this is the Original Referral
                if (Request.QueryString["from"] == "workingReferral")
                {
                    isOriginal = true;
                }
                else
                {
                    // reset the breadcrumbs
                    Session["breadCrumb"] = "";
                }

                // reset validator
                OKButtonValidator.IsValid = true;
                OKButtonValidator.ErrorMessage = "";
                OKButtonValidator.Visible = false;

                // Only used by new referrals
                int.TryParse(Request.QueryString["patientId"], out patientIdFromQueryString);

                if (int.TryParse(Request.QueryString["referralId"], out referralId))
                {
                    rc = new VIRP.EFR.BO.REFERRAL_EFR_COMPLETE(CurrentUser, CurrentRegistryId, referralId, patientIdFromQueryString, isOriginal);

                    SetupData();
                    LoadBioFollowups();
                    LoadWorkflows();

                    if (referralId == 0)
                    {
                        AddContactButton.Enabled = false;
                    }                    
                }

                SetupPatientNameControl();
                SetupReferralDetailControls();
                SetupDodFragmentMessage();

                //load dropdown data on initial load
                RefreshVAMCListAndSelectInstitution();

                foreach (ListItem item in WorkflowType.Items)
                {
                    foreach (KeyValuePair<int, string> wtl in rc.EfrWorkflowTypeList)
                    {
                        if (item.Text == "For Biomonitoring" &&
                            wtl.Value == "BIOLOGICAL MONITORING")
                        {
                            item.Value = wtl.Key.ToString();
                        }
                        else if (item.Text == "For Fragment Analysis" &&
                            wtl.Value == "FRAGMENT ANALYSIS")
                        {
                            item.Value = wtl.Key.ToString();
                        }
                    }
                }

                if (rc.Referral.REFERRAL_ID > 0)
                {
                    ReLoadInstitutionAddress(true);
                    ShowReferralFromEntity();
                    CheckReferralForDuplicates();
                    CheckAndSetupOriginalReferral();
                    RefreshClinicalReminderListAndSelectReminder();
                    CheckAndSetupVTABButton();

                    if (Request.QueryString["from"] == "workFlow" || Request.QueryString["from"] == "workingReferral")
                    {
                        SetBackButtonAsBackButtonOnBrowser();
                    }

                    // Handle Original Referral 
                    SetupOriginalReferralLink();
                }
                else
                {
                    SetupManualReferral();
                }

                SetPageTitle();
            }
            
            CancelButton.Text = "Back";

            if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrOpenCasesId
               || rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrClosedCasesId)
                SetupInProcessReferral();
            else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrIneligible)
                SetUpDeclinedReferral();
            else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrNoActionRequired)
                SetUpNoActionReferral();
            else // "EFR_NEW" or anything else
                SetUpNewReferral();
        }

        private void SetPageTitle()
        {
            if (Session["breadCrumb"] != null && Session["breadCrumb"].ToString().Length > 0)
            {
                ReplacePageTitle(Session["breadCrumb"].ToString());
            }
            else
            {
                string pageTitle = "My Tasks > Referrals";

                if (int.TryParse(Request.QueryString["referralId"], out referralId))
                {
                    if (referralId > 0)
                    {
                        if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrNewCasesId ||
                            rc.Referral.STD_REFERRALSTS_ID == 0)
                        {
                            pageTitle += " > New";
                        }
                        else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrOpenCasesId)
                        {
                            pageTitle += " > Open";
                        }
                        else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrIneligible)
                        {
                            pageTitle += " > Ineligible";
                        }
                        else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrNoActionRequired)
                        {
                            pageTitle += " > No Action Required";
                        }
                        else if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrClosedCasesId)
                        {
                            // This could be for closed or for Follow-ups
                            int statusId = 0;

                            if (int.TryParse(Request.QueryString["statusId"], out statusId))
                            {
                                if (statusId == 9999)
                                    pageTitle += " > Follow Ups";
                                else
                                    pageTitle += " > Closed";
                            }
                            else
                            {
                                pageTitle += " > Closed";
                            }
                        }
                        else if (rc.Referral.STD_REFERRALSTS_ID == rc.WcsEfrInProcess)
                        {
                            pageTitle += " > In Process";
                        }

                        if (referralId > 0)
                        {
                            ReplacePageTitle(pageTitle + " > Referral # " + referralId.ToString());
                            Session["breadCrumb"] = pageTitle + " > Referral # " + referralId.ToString();
                        }
                        else
                        {
                            ReplacePageTitle(pageTitle);
                            Session["breadCrumb"] = pageTitle;
                        }
                    }
                    else
                    {
                        ReplacePageTitle("My Tasks > Referrals > New");
                        Session["breadCrumb"] = "My Tasks > Referrals > New";
                    }
                }
                else
                {
                    ReplacePageTitle("My Tasks > Referrals > Referral #unknown");
                    Session["breadCrumb"] = "My Tasks > Referrals > Referral #unknown";
                }
            }
        }

        private void SetupData()
        {
            if (rc.Referral.REFERRAL_ID == 0)
            {
                SetupPatient_Reg();
                rc.Referral.CREATED = rc.Referral.UPDATED = DateTime.Now;
                rc.Referral.CREATEDBY = rc.Referral.UPDATEDBY = CurrentUser;

                rc.Referral_reg.CREATED = rc.Referral_reg.UPDATED = DateTime.Now;
                rc.Referral_reg.CREATEDBY = rc.Referral_reg.UPDATEDBY = CurrentUser;

                NameLabel.Text = rc.Patient.LAST_NAME + ", " + rc.Patient.FIRST_NAME + " " + rc.Patient.MIDDLE_NAME;
                PatientWorkflowsLink.Visible = false;
            }
            else
            {
                NameLabel.Visible = false;  // only show this for new referrals.
                PatientWorkflowsLink.Text = rc.Patient.LAST_NAME + ", " + rc.Patient.FIRST_NAME + " " + rc.Patient.MIDDLE_NAME;
                PatientWorkflowsLink.NavigateUrl = "~/Custom/EFR/Patients/PatientWorkflows.aspx?patientId=" + rc.Referral.PATIENT_ID.ToString();
            }

            VPIDLabel.Text = rc.Patient.PatientICN;
            ZipLabel.Text = rc.Patient_reg.POSTAL_CODE;
            LabelSSN.Text = rc.Patient_reg.Snum;
            LabelDOB.Text = (null == rc.Patient.BIRTH_DATE) ? "Unknown" : rc.Patient.BIRTH_DATE.Value.ToShortDateString();
            LabelServiceSeparationDate.Text = (rc.Patient_reg.LastServiceSeparationDate == null) ? "" : rc.Patient_reg.LastServiceSeparationDate.Value.ToShortDateString();

            if (rc.Patient.OEFOIF_IND == null)
                LabelOefOifIndicator.Text = "Unknown";
            else if ((bool)rc.Patient.OEFOIF_IND)
                LabelOefOifIndicator.Text = "Yes";
            else
                LabelOefOifIndicator.Text = "No";

            CheckBoxIraqAfghanService.Checked = rc.IraqAfghanService; 
        }

        private void SetupPatient_Reg()
        {
            VIRP_WEB.SoaServices.PATIENT p = ServiceInterfaceManager.PATIENT_GET_COMPLETE(CurrentUser, CurrentRegistryId, patientIdFromQueryString);

            if (p != null)
            {
                if (p.SPATIENT != null)
                {
                    rc.Patient_reg.PATIENT_ID = rc.Patient.PATIENT_ID;
                    rc.Patient_reg.Snum = p.SPATIENT.PatientSnum;
                    rc.Patient_reg.PATIENT_ICN = p.SPATIENT.PatientICN;
                    rc.Patient_reg.PatientICNCheckSUM = p.SPATIENT.PatientICNChecksum;
                    rc.Patient_reg.ADDRESS_LINE1 = p.SPATIENT.StreetAddress1;
                    rc.Patient_reg.ADDRESS_LINE2 = p.SPATIENT.StreetAddress2;
                    rc.Patient_reg.ADDRESS_LINE3 = p.SPATIENT.StreetAddress3;
                    rc.Patient_reg.CITY = p.SPATIENT.City;
                    rc.Patient_reg.STATE = p.SPATIENT.State;
                    rc.Patient_reg.COUNTY = p.SPATIENT.County;
                    rc.Patient_reg.COUNTRY = p.SPATIENT.Country;
                    rc.Patient_reg.POSTAL_CODE = p.SPATIENT.PostalCode;
                    rc.Patient_reg.HOME_PHONE = p.SPATIENT.PhoneResidence;
                    rc.Patient_reg.ZIP_PLUS_4 = p.SPATIENT.Zip4;
                    rc.Patient_reg.WORK_PHONE = p.SPATIENT.PhoneWork;
                    rc.Patient_reg.LastServiceSeparationDate = p.SPATIENT.LastServiceSeparationDate;
                }
            }
        }

        private void LoadBioFollowups()
        {
            BioFollowUpsRepeater.DataSource = rc.BioWkfCaseActivityList;
            BioFollowUpsRepeater.DataBind();
        }

        private void LoadWorkflows()
        {
            Workflows.DataSource = rc.WorkflowsDataSource;
            Workflows.DataBind();
        }

        private void SetBackButtonAsBackButtonOnBrowser()
        {
            CancelButton.PostBackUrl = "javascript:history.go(-1);";
            CancelButton.UseSubmitBehavior = false;
            CancelButton.ValidationGroup = "";
        }
        private void SetupDodFragmentMessage()
        {      
            if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrNewCasesId 
                || rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrOpenCasesId 
                || rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrClosedCasesId) 
            {
                LabelDoDFragmentMessage.Visible = true;
                LabelDoDFragmentDate.Visible = true;

                VIRP.EFR.BO.DoD_FRAGMENT_DATA_RECEIVELOG fragment = VIRP.EFR.BLL.DoD_FRAGMENT_DATA_RECEIVELOGManager.GetItemByPatientSnum(CurrentUser, CurrentRegistryId, rc.Patient_reg.Snum);
                
                if (fragment != null)
                {
                    LabelDoDFragmentMessage.Text = DodFragmentMessageMatch + "<br /><br />";
                }
                else
                {
                    LabelDoDFragmentMessage.Text = DodFragmentMessageNotMatch + "<br /><br />";
                }

                LabelDoDFragmentDate.Text = DodFragmentDateMessage;
                if (fragment != null && fragment.ORIGINALINPUTDATE != null)
                {
                    LabelDoDFragmentDate.Text = DodFragmentDateMessage + String.Format("{0:d}", fragment.ORIGINALINPUTDATE);
                }
                else
                {
                    LabelDoDFragmentDate.Text = DodFragmentDateMessage + "N/A";
                }
            }
            else
            {
                LabelDoDFragmentMessage.Visible = false;
                LabelDoDFragmentDate.Visible = false;
            }
        }

        private void RefreshClinicalReminderListAndSelectReminder()
        {
            LabelClinicalReminder.Text = "";

            bool injuredByBulletQ1 = false;
            bool blastExplosionInjuryQ2 = false;
            bool fragmentsRemovedInSurgeryQ3 = false;
            bool fragmentsInBodyQ4 = false;
            bool fragmentsOnRadiographQ4a = false;
            bool unableToScreen = false;
            bool healthFactorPresent = false;

            foreach (var rd in rc.ReferralDetailList)
            {
                switch (rd.STD_HEALTHFACTOR_ID)
                {
                    case 4:
                        injuredByBulletQ1 = true;
                        break;
                    case 3:
                        blastExplosionInjuryQ2 = true;
                        break;
                    case 13:
                        fragmentsRemovedInSurgeryQ3 = true;
                        break;
                    case 10:
                        fragmentsRemovedInSurgeryQ3 = false;
                        break;
                    case 29:
                        fragmentsRemovedInSurgeryQ3 = false;
                        break;
                    case 9:
                        fragmentsInBodyQ4 = true;
                        break;
                    case 22:
                        fragmentsInBodyQ4 = false;
                        break;
                    case 27:
                        fragmentsInBodyQ4 = false;
                        break;
                    case 12:
                        fragmentsOnRadiographQ4a = true;
                        break;
                    case 23:
                        fragmentsOnRadiographQ4a = false;
                        break;
                    case 28:
                        fragmentsOnRadiographQ4a = false;
                        break;
                    case 25:
                        unableToScreen = true;
                        break;
                    case 75:
                        unableToScreen = true;
                        break;
                    case 79:
                        unableToScreen = true;
                        break;

                    default:
                        break;
                }

                switch (rd.STD_HEALTHFACTOR_ID)
                {
                    case 4:
                    case 21:
                    case 3:
                    case 20:
                    case 18:
                    case 24:
                    case 17:
                    case 26:
                    case 19:
                    case 16:
                    case 8:
                    case 15:
                    case 2:
                    case 1:
                    case 13:
                    case 10:
                    case 29:
                    case 14:
                    case 11:
                    case 30:
                    case 9:
                    case 22:
                    case 27:
                    case 12:
                    case 23:
                    case 28:
                        healthFactorPresent = true;
                        break;
                    default:
                        break;
                }
            }

            //the patient has had a fragment removed at surgery or has a documented retained fragment
            if ((injuredByBulletQ1 || blastExplosionInjuryQ2)
                && (fragmentsRemovedInSurgeryQ3 || (fragmentsInBodyQ4 && fragmentsOnRadiographQ4a)))
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("LFRAGMENT");
            }

            //the patient has a high likelihood of having a retained fragment
            if ((injuredByBulletQ1 || blastExplosionInjuryQ2)
                && !fragmentsRemovedInSurgeryQ3
                && (fragmentsInBodyQ4 && !fragmentsOnRadiographQ4a))
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("HLFRAGMENT");
            }

            //the veteran possibly has a retained fragment as a result of injuries sustained while serving in the area of conflict
            if ((injuredByBulletQ1 || blastExplosionInjuryQ2)
                && !fragmentsRemovedInSurgeryQ3
                && !fragmentsInBodyQ4)
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("NLFRAGMENT");
            }

            //Unable to Screen
            if (unableToScreen && !healthFactorPresent)
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("UNABLESCREEN");
            }
            else if (!unableToScreen && !healthFactorPresent)
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("NOHEALTHFACTORSPRESENT");
            }
            //the veteran likely does not have a retained fragment as a result of injuries sustained while serving in the area of conflict
            else if (!injuredByBulletQ1
                && !blastExplosionInjuryQ2)
            {
                LabelClinicalReminder.Text = rc.GetStdReminderClassDescription("DFRAGMENT");
            }
        }

        protected override void LoadViewState(object savedState)
        {
            if (savedState != null)
            {
                // Load State from the array of objects that was saved at 
                // SavedViewState.
                object[] allStates = (object[])savedState;
                if (allStates[0] != null)
                    base.LoadViewState(allStates[0]);
                if (allStates[1] != null)
                    rc = (VIRP.EFR.BO.REFERRAL_EFR_COMPLETE)allStates[1];
                //if (allStates[2] != null)
                //{
                //    us = (UserSession)allStates[2];
                //    userName = CurrentUser;
                //    registryId = CurrentRegistryId;
                //}
            }
        }

        protected override object SaveViewState()
        {
            object baseState = base.SaveViewState();

            object[] allStates = new object[2];
            allStates[0] = baseState;
            allStates[1] = rc;
            //allStates[2] = us;

            return allStates;
        }

        protected void VTADataButton_Click(object sender, EventArgs e)
        {
            string url = "~/Custom/EFR/Referrals/VTAPatient.aspx?id=" + rc.Referral.REFERRAL_ID.ToString() + "&patientId=" + rc.Referral.PATIENT_ID.ToString();
            Response.Redirect(url, false);
        }

        protected void OKButton_Click(object sender, EventArgs e)
        {
            int statusId;

            //set appropriate status based on user selection or no selection at all 
            if (First.Checked)
                statusId = rc.SrsEfrOpenCasesId; 
            else if (Second.Checked)
                statusId = rc.SrsEfrIneligible; 
            else if (Third.Checked)
                statusId = rc.SrsEfrNoActionRequired; 
            else
                statusId = rc.Referral.STD_REFERRALSTS_ID;
                        
            //see if status has changed and do some operations if it does
            if (statusId != rc.Referral.STD_REFERRALSTS_ID)
            {
                rc.Referral.STD_REFERRALSTS_ID = statusId;

                if (rc.Referral.STD_REFERRALSTS_ID != rc.SrsEfrOpenCasesId)
                {
                    rc.Referral.REVIEW_BY = CurrentUser;
                    rc.Referral.REVIEW_DATE = DateTime.Now;
                }
                else
                {
                    rc.Referral.REVIEW_BY = "";
                    rc.Referral.REVIEW_DATE = null;
                }
                
                if (statusId == rc.SrsEfrOpenCasesId)
                {
                    //create each type requested workflow and assign some properties
                    foreach (ListItem item in WorkflowType.Items)
                    {
                        if (item.Selected)
                        {
                            int caseType = 0;

                            int.TryParse(item.Value, out caseType);

                            VIRP.CRS.BO.WKF_CASE wfCase = SetupWorkflowCase(caseType); 

                            //now add newly generated workflow to it's base referral 
                            rc.WorkflowCaseList.Add(wfCase);
                        }
                    }

                    //clear previous reasons if any present 
                    rc.Referral.COMMENT_TEXT = null;

                    SetupInProcessReferral();
                }
                else if (statusId == rc.SrsEfrClosedCasesId)
                {
                    rc.Referral.COMMENT_TEXT = null;

                    SetupInProcessReferral();
                }
                else if (statusId == rc.SrsEfrIneligible)
                {
                    rc.Referral.COMMENT_TEXT = TextIneligibleReason.Text;
                    SetUpDeclinedReferral();
                }
                else if (statusId == rc.SrsEfrNoActionRequired)
                {
                    SetUpNoActionReferral();
                }
            }

            try
            {
                SaveReferral();

                SetPageTitle();
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);

                OKButtonValidator.IsValid = false;
                OKButtonValidator.ErrorMessage = "There was an error processing your request: " + ex.Message;
                OKButtonValidator.Visible = true;
            }
        }

        protected void CancelButton_Click(object sender, EventArgs e)
        {
            string currentQueue = "4";
            int iCurrentQueue = -1;

            int.TryParse(Request.QueryString["statusId"], out iCurrentQueue);
            if (iCurrentQueue > -1)
            {
                currentQueue = iCurrentQueue.ToString();
            }
            else
            {
                currentQueue = rc.Referral.STD_REFERRALSTS_ID.ToString();
            }

            if (currentQueue == "9999")
            {
                Response.Redirect(string.Format("~/Custom/EFR/Referrals/BioContactFollowups.aspx"));
            }
            else
            {
                ResponseRedirect(ReferralsPage, currentQueue);
            }
        }

        private void SaveReferral()
        {                        
            //get modified values and do the update
            SetupSaveReferralFromPage();
            SetupSaveHealthFactorsFromPage();

            string hfids = "";
            string EFP_Comment = "";
            string BET_Comment = "";
            string AI_Comment = "";
            string SCI_Comment = "";
            string errorMessage = "";

            if (rc.Referral.REFERRAL_ID == 0)
            {
                // Set the patient's home VAMC to the one from SPatient if possible, but if not, use the one from the referral.

                int? std_institution_id = rc.Referral.STD_INSTITUTION_ID;

                if (rc.Patient != null)
                {
                    // Get the station id from sPatient, then use that to set the patient's home VAMC
                    VIRP_WEB.SoaServices.PATIENT patient = ServiceInterfaceManager.PATIENT_GET_COMPLETE(CurrentUser, CurrentRegistryId, rc.Patient.PATIENT_ID);

                    if (patient.SPATIENT != null && patient.SPATIENT.Sta3n != null)
                    {
                        List<VIRP_WEB.SoaServices.STD_INSTITUTION> siList = ServiceInterfaceManager.STD_INSTITUTION_GET_ALL(CurrentUser, CurrentRegistryId);

                        foreach (VIRP_WEB.SoaServices.STD_INSTITUTION si in siList)
                        {
                            if (patient.SPATIENT.Sta3n.ToString() == si.STATIONNUMBER)
                            {
                                std_institution_id = si.ID;
                            }
                        }
                    }
                }

                if (rc.Patient_reg != null)
                {
                    rc.Patient_reg.STD_INSTITUTION_ID = std_institution_id;
                }
            }

            SetupHealthFactorSaveRequest(ref hfids, ref EFP_Comment, ref BET_Comment, ref AI_Comment, ref SCI_Comment);

            // Save all data related to the referral

            if (rc.Referral.STD_INSTITUTION_ID != null && rc.Referral.STD_INSTITUTION_ID != rc.StdInstitution.ID)
            {
                rc.StdInstitution.ID = (int)rc.Referral.STD_INSTITUTION_ID;
            }

            rc.Referral.UPDATED = rc.Referral_reg.UPDATED = DateTime.Now;
            rc.Referral.UPDATEDBY = rc.Referral_reg.UPDATEDBY = CurrentUser;

            try
            {
               rc.Save(CurrentUser, CurrentRegistryId, hfids, EFP_Comment, BET_Comment, AI_Comment, SCI_Comment);

                ClientScript.RegisterStartupScript(typeof(Page), "alertMessage", "<script type='text/javascript'>alert('Save Successful');</script>");
            }
            catch (Exception e)
            {
                OKButtonValidator.IsValid = false;
                OKButtonValidator.ErrorMessage = errorMessage + e.Message;
                OKButtonValidator.Visible = true;
                OKButtonValidator.Display = ValidatorDisplay.Dynamic;

                ServiceInterfaceManager.LogError(e.ToString(), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }

            if (Request.QueryString["referralId"] == "0")
            {
                string url = "~/Custom/EFR/Referrals/referral.aspx?referralId=" + rc.Referral.REFERRAL_ID.ToString();

                Response.Redirect(url, false);
            }
            else
            {
                GetRefreshReferral(rc.Referral.REFERRAL_ID);
                ShowReferralFromEntity();
                ReBindChangedData();
                RefreshClinicalReminderListAndSelectReminder();
            }
        }
        
        private void SetupManualReferral()
        {
            VTADataButton.Visible = false;
        }

        private void SetupReferralDetailControls()
        {
            bool manualReferral = (rc.Referral.REFERRAL_ID == 0);

            if (rc.Referral.REFERRAL_ID > 0)
            {
                if (rc.Referral.CREATEDBY.Contains("\\"))
                {
                    manualReferral = true;
                }                
            }

           if (manualReferral)
            {
                TEFSCDateForLabel.Visible = false;
                TEFSCDateLabel.Visible = false;
                ReviewedDateLabel.Visible = false;
                ReviewedDateBox.Visible = false;
                ReviewedByLabel.Visible = false;
                ReviewedByBox.Visible = false;
                LabelCreatedBy.Text = CurrentUser;
                LabelReferralDate.Text = String.Format("{0:d}", DateTime.Now);
            }
        }

        private void SetupPatientNameControl()
        {
            if (rc.Referral.REFERRAL_ID > 0)
            {
                PatientWorkflowsLink.Visible = true;
            }
            else
            {
                PatientWorkflowsLink.Visible = false;
            }
        }

        private void SetUpNewReferral()
        {
            PanelChecklist.Visible = true;
            PanelWorkflows.Visible = false;

            PanelNoActionIneligible.Visible = false;
        }

        private void SetUpNoActionReferral()
        {
            PanelChecklist.Visible = false;
            PanelWorkflows.Visible = false;

            PanelNoActionIneligible.Visible = true;

            IneligibilityReason.Text = "No action Required";
        }

        private void SetupInProcessReferral()
        {
            PanelChecklist.Visible = false;
            PanelWorkflows.Visible = true;

            PanelNoActionIneligible.Visible = false;
        }

        //referral was declined so no workflows are visible, only declined reason
        private void SetUpDeclinedReferral()
        {
            PanelChecklist.Visible = false;
            PanelWorkflows.Visible = false;

            PanelNoActionIneligible.Visible = true;

            string spaces = "";

            for (int i = 0; i < 30; i++)
                spaces += "&nbsp;";

            IneligibilityReason.Text = "Ineligible" + spaces + "Reason: " + AntiXssEncoder.HtmlEncode(rc.Referral.COMMENT_TEXT, false);
        }
        
        //private void SetUpClosedReferral()
        //{
        //}

        private void SetupOriginalReferralLink()
        {
            int numReferrals = VIRP.EFR.BLL.REFERRALManager.GetReferralOriginalRecordCount(CurrentUser, CurrentRegistryId, rc.Referral.REFERRAL_ID);

            int iNumReferrals = 0;

            if (int.TryParse(numReferrals.ToString(), out iNumReferrals))
            {
                if (iNumReferrals >= 1 && !isOriginal)
                {
                    hlOriginalReferral.Visible = true;

                    hlOriginalReferral.NavigateUrl =
                        HttpContext.Current.Request.Url.AbsoluteUri.Substring(0,
                            HttpContext.Current.Request.Url.AbsoluteUri.IndexOf('?')) +
                            "?referralId=" + rc.Referral.REFERRAL_ID + "&from=workingReferral";
                }
            }
        }

        private void GetRefreshReferral(int rId)
        {
            LoadWorkflows();
        }

        private void CheckAndSetupVTABButton()
        {
            // It doesn't appear we populate this data any longer. Keeping since the framework for it is still in place.

            VTADataButton.Visible = false; // referral.PATIENT.VTA_PATIENTs.Count() > 0;

            List<VIRP.EFR.BO.VTA_PATIENT> patients = VIRP.EFR.BLL.VTA_PATIENTManager.GetItems(CurrentUser, CurrentRegistryId);

            foreach (VIRP.EFR.BO.VTA_PATIENT p in patients)
            {
                if (p.Patient_ID != null && (int)p.Patient_ID == rc.Referral.PATIENT_ID)
                {
                    VTADataButton.Visible = true;
                    break;
                }
            }
        }

        private void ReBindChangedData()
        {
            if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrOpenCasesId)
                Workflows.DataBind();
        }
        
        private void ShowReferralFromEntity()
        {
            LabelReferralDate.Text = String.Format("{0:d}", rc.Referral.REFERRAL_DATE);
            TEFSCDateLabel.Text = String.Format("{0:d}", rc.Referral.CREATED);
            LabelCreatedBy.Text = rc.Referral.CREATEDBY;

            //hide these on new referrals
            if (rc.Referral.STD_REFERRALSTS_ID == rc.SrsEfrNewCasesId) 
            {
                ReviewedDateBox.Text = String.Empty;
                ReviewedByBox.Text = String.Empty;
            }
            else
            {
                ReviewedDateBox.Text = String.Format("{0:d}", rc.Referral.REVIEW_DATE);
                if (rc.Referral.REVIEW_BY == null)
                {
                    ReviewedByBox.Text = "";
                }
                else
                {
                    ReviewedByBox.Text = rc.Referral.REVIEW_BY;
                }
            }

            //VAMC related information
            VAMCContactName.Text = rc.Referral_reg.VAMC_CONTACT_NAME;
            VAMCContactEMail.Text = rc.Referral_reg.VAMC_CONTACT_EMAIL;
            VAMCContactFAX.Text = rc.Referral_reg.VAMC_CONTACT_FAX;
            VAMCContactPhone.Text = rc.Referral_reg.VAMC_CONTACT_PHONE;

            //PCP information 
            PCPEMail.Text = rc.Referral_reg.PROVIDER_EMAIL;
            PCPName.Text = rc.Referral_reg.PROVIDER_NAME;
            PCPPhone.Text = rc.Referral_reg.PROVIDER_PHONE;
            PCPFax.Text = rc.Referral_reg.PROVIDER_FAX;
            PCPAddress1.Text = rc.Referral_reg.PROVIDER_ADDRESS_LINE1;
            PCPAddress2.Text = rc.Referral_reg.PROVIDER_ADDRESS_LINE2;
            PCPAddress3.Text = rc.Referral_reg.PROVIDER_ADDRESS_LINE3;
            PCPCity.Text = rc.Referral_reg.PROVIDER_CITY;
            PCPState.Text = rc.Referral_reg.PROVIDER_STATE;
            PCPCountry.Text = rc.Referral_reg.PROVIDER_COUNTRY;
            PCPPostal.Text = rc.Referral_reg.PROVIDER_POSTAL_CODE;

            TextIneligibleReason.Text = rc.Referral_reg.COMMENT_TEXT;

            SetupHealthFactors();
        }

        private void RefreshVAMCListAndSelectInstitution()
        {
            VAMCFAcilityNamesListBox.Items.Clear();
            VAMCFAcilityNamesListBox.Items.Add(new ListItem("(Please select institution)", "0"));
            VAMCFAcilityNamesListBox.Items.AddRange(VIRP_WEB.BaseCode.Helpers.GetInsitutionList(CurrentUser, CurrentRegistryId).Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());

            if (rc.Referral.STD_INSTITUTION_ID.HasValue && rc.Referral.STD_INSTITUTION_ID > 0)
            {
                VAMCFAcilityNamesListBox.SelectedIndex = VAMCFAcilityNamesListBox.Items.IndexOf(VAMCFAcilityNamesListBox.Items.FindByValue(rc.Referral.STD_INSTITUTION_ID.GetValueOrDefault().ToString()));
            }
            else if (rc.Referral.STD_INSTITUTION != null)
            {
                VAMCFAcilityNamesListBox.SelectedIndex = VAMCFAcilityNamesListBox.Items.IndexOf(VAMCFAcilityNamesListBox.Items.FindByValue(rc.Referral.STD_INSTITUTION.ID.ToString()));
            }
            else
            {
                VAMCFAcilityNamesListBox.SelectedIndex = 0;
            }
        }

        protected void AddContact_Click(object sender, EventArgs e)
        {
            Response.Redirect(string.Format("ReferralContact.aspx?referralId={0}", rc.Referral.REFERRAL_ID));
        }

        protected void BtnPushData_Click(object sender, EventArgs e)
        {
            try
            {
                if (WorkingRefId.Value.Length > 0 && Convert.ToInt32(WorkingRefId.Value) > 0)
                {
                    string hfids = "";
                    string EFP_Comment = "";
                    string BET_Comment = "";
                    string AI_Comment = "";
                    string SCI_Comment = "";

                    SetupHealthFactorSaveRequest(ref hfids, ref EFP_Comment, ref BET_Comment, ref AI_Comment, ref SCI_Comment);

                    rc.PushToWorkingReferral(hfids, EFP_Comment, BET_Comment, AI_Comment, SCI_Comment, Convert.ToInt32(WorkingRefId.Value));

                    ServiceInterfaceManager.LogInformation("Pushed referral: " + WorkingRefId.Value + " to referral: " + rc.Referral.REFERRAL_ID.ToString(),
                        string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name),
                        CurrentUser,
                        CurrentRegistryId);

                    ClientScript.RegisterStartupScript(typeof(Page), "alertMessage", "<script type='text/javascript'>alert('Working referral was successfully updated');</script>");
                }
                else
                {
                    ServiceInterfaceManager.LogInformation("Failed trying to pushed referral: " + WorkingRefId.Value + " to referral: " + rc.Referral.REFERRAL_ID.ToString() + ": Invalid duplicate referral ID", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failed trying to pushed referral: " + ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }
        }
        protected void ClearButton_Click(object sender, EventArgs e)
        {
            rc.Referral.STD_REFERRALSTS_ID = rc.SrsEfrNewCasesId;
            rc.Referral.COMMENT_TEXT = null;

            rc.Referral.DUPLICATE_FLAG = false;

            SaveReferral();

            SuppressSaveSuccessMessage = true;

            GetRefreshReferral(rc.Referral.REFERRAL_ID);

            //re-load referral since we just saved it
            ShowReferralFromEntity();
            ReBindChangedData();

            SetUpNewReferral();

            SetPageTitle();
        }
        
        private void ReLoadInstitutionAddress(bool useReferralAddress)
        {     
            if (useReferralAddress)
            {
                if (String.IsNullOrEmpty(rc.Referral_reg.ADDRESS_LINE1))
                {
                    if (String.IsNullOrEmpty(rc.StdInstitution.MAILINGADDRESSLINE1))
                    {
                        VAMCAddress1Box.Text = rc.StdInstitution.STREETADDRESSLINE1;
                        VAMCAddress2Box.Text = rc.StdInstitution.STREETADDRESSLINE2;
                        VAMCAddress3Box.Text = rc.StdInstitution.STREETADDRESSLINE3;
                        VAMCAddressCity.Text = rc.StdInstitution.STREETCITY;
                        VAMCAddressPostal.Text = rc.StdInstitution.STREETPOSTALCODE;
                        if (rc.StdInstitution.STREETSTATE_ID.HasValue)
                        {
                            VAMCAddressState.Text = rc.StdInstitution.STREETSTATE.POSTALNAME;
                        }

                        if (rc.StdInstitution.STREETCOUNTRY_ID.HasValue)
                        {
                            VIRP.CRS.BO.STD_COUNTRY sc = VIRP.CRS.BLL.STD_COUNTRYManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.STREETCOUNTRY_ID);
                            VAMCAddressCountry.Text = sc.FIPSCODE;
                        }
                    }
                    else
                    {
                        VAMCAddress1Box.Text = rc.StdInstitution.MAILINGADDRESSLINE1;
                        VAMCAddress2Box.Text = rc.StdInstitution.MAILINGADDRESSLINE2;
                        VAMCAddress3Box.Text = rc.StdInstitution.MAILINGADDRESSLINE3;
                        VAMCAddressCity.Text = rc.StdInstitution.MAILINGCITY;
                        VAMCAddressPostal.Text = rc.StdInstitution.MAILINGPOSTALCODE;
                        if (rc.StdInstitution.MAILINGSTATE_ID.HasValue)
                        {
                            VIRP.CRS.BO.STD_STATE st = VIRP.CRS.BLL.STD_STATEManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.MAILINGSTATE_ID);
                            VAMCAddressState.Text = st.POSTALNAME;
                        }

                        if (rc.StdInstitution.MAILINGCOUNTRY_ID.HasValue)
                        {
                            VIRP.CRS.BO.STD_COUNTRY sc = VIRP.CRS.BLL.STD_COUNTRYManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.MAILINGCOUNTRY_ID);
                            VAMCAddressCountry.Text = sc.FIPSCODE;
                        }
                    }
                }
                else
                {
                    VAMCAddress1Box.Text = rc.Referral_reg.ADDRESS_LINE1;
                    VAMCAddress2Box.Text = rc.Referral_reg.ADDRESS_LINE2;
                    VAMCAddress3Box.Text = rc.Referral_reg.ADDRESS_LINE3;
                    VAMCAddressCity.Text = rc.Referral_reg.CITY;
                    VAMCAddressPostal.Text = rc.Referral_reg.POSTAL_CODE;
                    VAMCAddressState.Text = rc.Referral_reg.STATE;
                    VAMCAddressCountry.Text = rc.Referral_reg.COUNTRY;
                }
            }
            else
            {
                if (String.IsNullOrEmpty(rc.StdInstitution.MAILINGADDRESSLINE1))
                {
                    VAMCAddress1Box.Text = rc.StdInstitution.STREETADDRESSLINE1;
                    VAMCAddress2Box.Text = rc.StdInstitution.STREETADDRESSLINE2;
                    VAMCAddress3Box.Text = rc.StdInstitution.STREETADDRESSLINE3;
                    VAMCAddressCity.Text = rc.StdInstitution.STREETCITY;
                    VAMCAddressPostal.Text = rc.StdInstitution.STREETPOSTALCODE;
                    if (rc.StdInstitution.STREETSTATE_ID.HasValue)
                    {
                        VAMCAddressState.Text = rc.StdInstitution.STREETSTATE.POSTALNAME;
                    }

                    if (rc.StdInstitution.STREETCOUNTRY_ID.HasValue)
                    {
                        VIRP.CRS.BO.STD_COUNTRY sc = VIRP.CRS.BLL.STD_COUNTRYManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.STREETCOUNTRY_ID);
                        VAMCAddressCountry.Text = sc.FIPSCODE;
                    }
                }
                else
                {
                    VAMCAddress1Box.Text = rc.StdInstitution.MAILINGADDRESSLINE1;
                    VAMCAddress2Box.Text = rc.StdInstitution.MAILINGADDRESSLINE2;
                    VAMCAddress3Box.Text = rc.StdInstitution.MAILINGADDRESSLINE3;
                    VAMCAddressCity.Text = rc.StdInstitution.MAILINGCITY;
                    VAMCAddressPostal.Text = rc.StdInstitution.MAILINGPOSTALCODE;
                    if (rc.StdInstitution.MAILINGSTATE_ID.HasValue)
                    {
                        VIRP.CRS.BO.STD_STATE st = VIRP.CRS.BLL.STD_STATEManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.MAILINGSTATE_ID);
                        VAMCAddressState.Text = st.FIPSCODE;
                    }

                    if (rc.StdInstitution.MAILINGCOUNTRY_ID.HasValue)
                    {
                            VIRP.CRS.BO.STD_COUNTRY sc = VIRP.CRS.BLL.STD_COUNTRYManager.GetItem(CurrentUser, CurrentRegistryId, (int)rc.StdInstitution.MAILINGCOUNTRY_ID);
                            VAMCAddressCountry.Text = sc.FIPSCODE;
                    }
                }
            }
        }

        private void SetupSaveReferralFromPage()
        {
            rc.Referral_reg.VAMC_CONTACT_NAME = VAMCContactName.Text.Trim();
            rc.Referral_reg.VAMC_CONTACT_EMAIL = VAMCContactEMail.Text.Trim();
            rc.Referral_reg.VAMC_CONTACT_FAX = VAMCContactFAX.Text.Trim();
            rc.Referral_reg.VAMC_CONTACT_PHONE = VAMCContactPhone.Text.Trim();

            rc.Referral_reg.PROVIDER_EMAIL = PCPEMail.Text.Trim();
            rc.Referral_reg.PROVIDER_NAME = PCPName.Text.Trim();
            rc.Referral_reg.PROVIDER_PHONE = PCPPhone.Text.Trim();
            rc.Referral_reg.PROVIDER_FAX = PCPFax.Text.Trim();
            rc.Referral_reg.PROVIDER_ADDRESS_LINE1 = PCPAddress1.Text.Trim();
            rc.Referral_reg.PROVIDER_ADDRESS_LINE2 = PCPAddress2.Text.Trim();
            rc.Referral_reg.PROVIDER_ADDRESS_LINE3 = PCPAddress3.Text.Trim();
            rc.Referral_reg.PROVIDER_CITY = PCPCity.Text.Trim();
            rc.Referral_reg.PROVIDER_STATE = PCPState.Text.Trim();
            rc.Referral_reg.PROVIDER_COUNTRY = PCPCountry.Text.Trim();
            rc.Referral_reg.PROVIDER_POSTAL_CODE = PCPPostal.Text.Trim();

            //referral institution information 
            rc.Referral_reg.ADDRESS_LINE1 = VAMCAddress1Box.Text.Trim();
            rc.Referral_reg.ADDRESS_LINE2 = VAMCAddress2Box.Text.Trim();
            rc.Referral_reg.ADDRESS_LINE3 = VAMCAddress3Box.Text.Trim();
            rc.Referral_reg.CITY = VAMCAddressCity.Text.Trim();
            rc.Referral_reg.POSTAL_CODE = VAMCAddressPostal.Text.Trim();
            rc.Referral_reg.STATE = VAMCAddressState.Text.Trim();
            rc.Referral_reg.COUNTRY = VAMCAddressCountry.Text.Trim();

            if (VAMCFAcilityNamesListBox.SelectedIndex > 0)
            {
                int id = 0;
                if (int.TryParse(VAMCFAcilityNamesListBox.SelectedValue, out id))
                {
                    rc.Referral.STD_INSTITUTION_ID = id;
                }
                else
                {
                    rc.Referral.STD_INSTITUTION_ID = null;
                }
            }
            else
            {
                rc.Referral.STD_INSTITUTION_ID = null;
            }

            if (rc.Referral.REFERRAL_ID == 0)
            {
                int patientId = 0;
                if (int.TryParse(Request.QueryString["patientId"], out patientId))
                {
                    if (patientId > 0)
                    {
                        rc.Referral.PATIENT_ID = rc.Patient.PATIENT_ID;
                        rc.Referral.REFERRAL_DATE = DateTime.Now;

                        if (rc.Referral.STD_REFERRALSTS_ID == 0)
                        {
                            rc.Referral.STD_REFERRALSTS_ID = rc.SrsEfrNewCasesId; // rc.referralStatus.ID;
                        }
                    }
                }
            }
        }

        //this is a function that sets up healthfactor area according to referral health factors
        private void SetupHealthFactors()
        {
            // Disable all comment boxes, then enable as needed
            EFRPresentBox.Enabled = false;
            BlastSourceOtherBox.Enabled = false;
            CognitiveImpairmentBox.Enabled = false;
            AcuteIllnessBox.Enabled = false;

            foreach (VIRP.EFR.BO.REFERRAL_DETAIL rd in rc.ReferralDetailList)
            {
                SetupHeathFactor(rd);
            }
        }

        private void SetupHeathFactor(VIRP.EFR.BO.REFERRAL_DETAIL rd)
        {
            foreach (ListItem cb in CheckBoxListHealthFactors1.Items)
            {
                if (cb.Value == "69" && rd.STD_HEALTHFACTOR_ID == 69)
                {
                    cb.Selected = true;
                    EFRPresentBox.Text = rd.COMMENT_TEXT;
                    EFRPresentBox.Enabled = true;
                }
                else if (cb.Value == "70" && rd.STD_HEALTHFACTOR_ID == 70)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors9.Items)
            {
                if (cb.Value == "4" && rd.STD_HEALTHFACTOR_ID == 4)
                    cb.Selected = true;
                else if (cb.Value == "21" && rd.STD_HEALTHFACTOR_ID == 21)
                    cb.Selected = true;
                else if (cb.Value == "3" && rd.STD_HEALTHFACTOR_ID == 3)
                    cb.Selected = true;
                else if (cb.Value == "20" && rd.STD_HEALTHFACTOR_ID == 20)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors3.Items)
            {
                if (cb.Value == "17" && rd.STD_HEALTHFACTOR_ID == 17)
                    cb.Selected = true;
                else if (cb.Value == "26" && rd.STD_HEALTHFACTOR_ID == 26)
                    cb.Selected = true;
                else if (cb.Value == "19" && rd.STD_HEALTHFACTOR_ID == 19)
                    cb.Selected = true;
                else if (cb.Value == "16" && rd.STD_HEALTHFACTOR_ID == 16)
                    cb.Selected = true;
                else if (cb.Value == "8" && rd.STD_HEALTHFACTOR_ID == 8)
                    cb.Selected = true;
                else if (cb.Value == "15" && rd.STD_HEALTHFACTOR_ID == 15)
                    cb.Selected = true;
                else if (cb.Value == "2" && rd.STD_HEALTHFACTOR_ID == 2)
                    cb.Selected = true;
                else if (cb.Value == "1" && rd.STD_HEALTHFACTOR_ID == 1)
                {
                    cb.Selected = true;
                    BlastSourceOtherBox.Text = rd.COMMENT_TEXT;
                    BlastSourceOtherBox.Enabled = true;
                }
            }

            foreach (ListItem cb in CheckBoxListHealthFactors5.Items)
            {
                if (cb.Value == "9" && rd.STD_HEALTHFACTOR_ID == 9)
                    cb.Selected = true;
                else if (cb.Value == "22" && rd.STD_HEALTHFACTOR_ID == 22)
                    cb.Selected = true;
                else if (cb.Value == "27" && rd.STD_HEALTHFACTOR_ID == 27)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors4.Items)
            {
                if (cb.Value == "12" && rd.STD_HEALTHFACTOR_ID == 12)
                    cb.Selected = true;
                else if (cb.Value == "23" && rd.STD_HEALTHFACTOR_ID == 23)
                    cb.Selected = true;
                else if (cb.Value == "28" && rd.STD_HEALTHFACTOR_ID == 28)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors8.Items)
            {
                if (cb.Value == "18" && rd.STD_HEALTHFACTOR_ID == 18)
                    cb.Selected = true;
                else if (cb.Value == "24" && rd.STD_HEALTHFACTOR_ID == 24)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors2.Items)
            {
                if (cb.Value == "13" && rd.STD_HEALTHFACTOR_ID == 13)
                    cb.Selected = true;
                else if (cb.Value == "10" && rd.STD_HEALTHFACTOR_ID == 10)
                    cb.Selected = true;
                else if (cb.Value == "29" && rd.STD_HEALTHFACTOR_ID == 29)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors7.Items)
            {
                if (cb.Value == "14" && rd.STD_HEALTHFACTOR_ID == 14)
                    cb.Selected = true;
                else if (cb.Value == "11" && rd.STD_HEALTHFACTOR_ID == 11)
                    cb.Selected = true;
                else if (cb.Value == "30" && rd.STD_HEALTHFACTOR_ID == 30)
                    cb.Selected = true;
            }

            foreach (ListItem cb in CheckBoxListHealthFactors10.Items)
            {
                if (cb.Value == "75" && rd.STD_HEALTHFACTOR_ID == 75)
                {
                    cb.Selected = true;
                    AcuteIllnessBox.Text = rd.COMMENT_TEXT;
                    AcuteIllnessBox.Enabled = true;
                }
                else if (cb.Value == "79" && rd.STD_HEALTHFACTOR_ID == 79)
                {
                    cb.Selected = true;
                    CognitiveImpairmentBox.Text = rd.COMMENT_TEXT;
                    CognitiveImpairmentBox.Enabled = true;
                }
                else if (cb.Value == "25" && rd.STD_HEALTHFACTOR_ID == 25)
                    cb.Selected = true;
            }
        }

        private void SetupSaveHealthFactorsFromPage()
        {    
            foreach (ListItem cb in CheckBoxListHealthFactors1.Items) // 69  70
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected); 
            }
            foreach (ListItem cb in CheckBoxListHealthFactors9.Items) // 4  21  3  20
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors3.Items) // 17 26 19 16 8 15 2 1 
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors5.Items)  // 9  22 27
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors4.Items)  // 12 23 28
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors8.Items) // 18 24
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors2.Items) // 13 10 29
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors7.Items) // 14 11 30
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
            foreach (ListItem cb in CheckBoxListHealthFactors10.Items) // 75 79 25
            {
                AddDeleteReferralDetail(Convert.ToInt32(cb.Value), cb.Selected);
            }
        }

        private void AddDeleteReferralDetail(int hfId, bool add)
        {
            string comment = "";
            bool found = false;

            // Find the health factor in the list of health factors, if possible
            for (int i = 0; i < rc.ReferralDetailList.Count; i++)
            { 
                if (rc.ReferralDetailList[i].STD_HEALTHFACTOR_ID == hfId)
                {
                    // We found it. Now determine if we are adding it or deleting it.

                    found = true;

                    if (add)
                    {
                        // Adding this one, but it already exists, so the only thing
                        // needed is to update the comment for any of the HF's below

                        comment = GetCommentForReferralDetail(hfId);

                        if (comment.Length > 0)
                        {
                            rc.ReferralDetailList[i].COMMENT_TEXT = comment;
                        }
                    }
                    else
                    {
                        // Delete this health factor
                        rc.ReferralDetailList.RemoveAt(i);
                    }
                }
            }

            // We did not find the HF in the list, add it if necessary
            if (!found && add)
            {
                // Create a new HF and add to the list
                VIRP.EFR.BO.REFERRAL_DETAIL nrd = new VIRP.EFR.BO.REFERRAL_DETAIL();
                nrd.REFERRAL_ID = rc.Referral.REFERRAL_ID;
                nrd.CREATEDBY = CurrentUser;
                nrd.UPDATEDBY = CurrentUser;
                nrd.STD_HEALTHFACTOR_ID = hfId;

                comment = GetCommentForReferralDetail(hfId);

                if (comment.Length > 0)
                {
                    nrd.COMMENT_TEXT = comment;
                }

                rc.ReferralDetailList.Add(nrd);
            }               
        }

        private string GetCommentForReferralDetail(int factorId)
        {
            string retValue = "";

            switch (factorId)
            {
                case 69:
                    retValue = EFRPresentBox.Text;
                    break;

                case 1:
                    retValue = BlastSourceOtherBox.Text;
                    break;

                case 79:
                    retValue = CognitiveImpairmentBox.Text;
                    break;

                case 75:
                    retValue = AcuteIllnessBox.Text;
                    break;
            }

            return retValue;
        }
        
        private void SetupHealthFactorSaveRequest(ref string hfids, ref string EFP_Comment, ref string BET_Comment, ref string AI_Comment, ref string SCI_Comment)
        {
            hfids = "";  

            foreach (VIRP.EFR.BO.REFERRAL_DETAIL rd in rc.ReferralDetailList)
            {
                if (hfids.Length == 0)
                    hfids = rd.STD_HEALTHFACTOR_ID.ToString() + ",";
                else
                    hfids += rd.STD_HEALTHFACTOR_ID.ToString() + ",";
            }

            // Set the comment boxes. We can do this blindly since it won't be updated unless there's a corresponding 
            // health factor set.

            if (hfids.Length > 0)
            {
                //strip the trailing comma
                hfids = hfids.TrimEnd(',');
            }

            EFP_Comment = EFRPresentBox.Text.Trim();
            BET_Comment = BlastSourceOtherBox.Text.Trim();
            SCI_Comment = CognitiveImpairmentBox.Text.Trim();
            AI_Comment = AcuteIllnessBox.Text;
        }

        private void CheckReferralForDuplicates()
        {
            VIRP.CRS.BO.REFERRAL duplicate = VIRP.EFR.BLL.REFERRALManager.GetDuplicate(CurrentUser, CurrentRegistryId, rc.Referral.REFERRAL_ID, rc.Patient_reg.Snum);

            if (duplicate != null)
            {
                PanelReferralDuplicate.Visible = true;
                LabelDuplicateHeader.Text = "Duplicate";
                DuplicateWording.Text = "This is a duplicate of a previously triaged referral. You will not be able to accept it, but may review and edit the previously triaged referral by following the link below.";

                DuplicateOriginalLink.Text = "Go to Previously Triaged Referral";
                DuplicateOriginalLink.NavigateUrl = Request.Url.AbsolutePath + "?referralId=" + duplicate.REFERRAL_ID;
                WorkingRefId.Value = duplicate.REFERRAL_ID.ToString();

                rc.Referral.DUPLICATE_FLAG = true;
                rc.Referral.COMMENT_TEXT = "Duplicate";

                // only show the Push button to TEFSC administrators for manually created referrals (unless otherwise configured)
                try
                {
                    if ((UserSession.IsRegistryAdministrator || UserSession.IsSystemAdministrator) 
                        && (duplicate.CREATEDBY.Contains("\\"))) 
                    {
                        btnPushData.Visible = true;
                    }
                }
                catch (Exception ex)
                {
                    ServiceInterfaceManager.LogError(ex.ToString(), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
                }

                First.Enabled = false;
                Second.Enabled = true;
                Third.Enabled = false;
                Inner1.Enabled = false;
                TextIneligibleReason.Text = "Duplicate";
            }
        }

        private void CheckAndSetupOriginalReferral()
        {
            if (Request.UrlReferrer != null)
            {
                string originalURL = Request.UrlReferrer.AbsoluteUri.ToString();
                string returnURL = originalURL;
                string leftPartOfQueryString = "referral.aspx?referralId=";
                string refId = "";

                if ((originalURL.IndexOf(leftPartOfQueryString, StringComparison.CurrentCultureIgnoreCase) > 0
                    && !originalURL.Contains("patientId=")))
                {
                    int paramStartLoc = originalURL.IndexOf('&');

                    if (paramStartLoc > -1)   // Cut off second+ parameters
                    {
                        originalURL = originalURL.Substring(0, paramStartLoc);
                    }

                    // get the referralId 
                    int startOfRefId = originalURL.IndexOf("referralId=") + "referralId=".Length;
                    refId = originalURL.Substring(startOfRefId, originalURL.Length - startOfRefId);

                    PanelReferralDuplicate.Visible = true;

                    if (isOriginal)
                    {
                        // We are viewing the original referral
                        PanelReferralDuplicate.Visible = true;

                        if (rc.Referral.DUPLICATE_FLAG == true)
                        {
                            LabelDuplicateHeader.Text = "Original Referral Data for Duplicate Referral";
                            DuplicateOriginalLink.Text = "Go back to Duplicate Referral";
                            DuplicateWording.Text = "&nbsp;";
                        }
                        else
                        {
                            LabelDuplicateHeader.Text = "Original Referral Data for Working Referral";
                            DuplicateOriginalLink.Text += "Go back to Working Referral";
                        }

                        DuplicateOriginalLink.NavigateUrl = returnURL; // Request.Url.AbsolutePath + "?referralId=" + refId + "&from=originalReferral";

                        // Since this is read-only view, disable all controls
                        PanelDetails.Enabled = false;
                        PanelHealthfactors.Enabled = false;
                        PanelWorkflows.Enabled = false;
                        ButtonSave.Enabled = false;
                        OKButton.Enabled = false;
                        AddContactButton.Enabled = false;
                        PanelNoActionIneligible.Enabled = false;
                        PanelChecklist.Enabled = false;
                        PanelNoActionIneligible.Enabled = false;
                    }
                    else if (rc.Referral.DUPLICATE_FLAG == true)
                    {
                        PanelReferralDuplicate.Visible = true;
                    }
                    else if (returnURL.Contains("workingReferral"))
                    {
                        // Do not show panel if we navigated to the Original view, then are coming
                        // back to the working referral

                        PanelReferralDuplicate.Visible = false;
                    }
                    else
                    {
                        // We navigated from the duplicate referral to the working referral
                        // Show the panel in this case

                        LabelDuplicateHeader.Text = "Previously Triaged Referral";

                        DuplicateOriginalLink.Text = "Go back to Duplicate Referral";
                        DuplicateOriginalLink.NavigateUrl = Request.Url.AbsolutePath + "?referralId=" + refId;
                    }
                }
            }
        }

        protected void Workflows_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.EmptyDataRow)
            {
                DropDownList ddlWFEmptyTypes = Workflows.Controls[0].Controls[0].FindControl("WorkflowTypesEmptyList") as DropDownList;
                if (ddlWFEmptyTypes != null)
                {
                    ddlWFEmptyTypes.Items.Clear();
                    ddlWFEmptyTypes.Items.Add(new ListItem("(Select One)", "0"));
                    ddlWFEmptyTypes.Items.AddRange(rc.EfrWorkflowTypeList.Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
                    ddlWFEmptyTypes.SelectedIndex = 0;
                }
            }
            else if (e.Row.RowType == DataControlRowType.Footer)
            {
                DropDownList ddlWFTypes = e.Row.FindControl("WorkflowTypesList") as DropDownList;
                if (ddlWFTypes != null)
                {
                    ddlWFTypes.Items.Clear();
                    ddlWFTypes.Items.Add(new ListItem("(Select One)", "0"));
                    ddlWFTypes.Items.AddRange(rc.GetWorkflowTypeList(CurrentUser, CurrentRegistryId).Select(kvp => new ListItem(kvp.Value, kvp.Key.ToString())).ToArray());
                    ddlWFTypes.SelectedIndex = 0;
                }
            }
        }

        protected void BioFollowUpsRepeater_ItemCommand(object source, RepeaterCommandEventArgs e)
        {
            HiddenField hiddenID = (HiddenField)e.Item.FindControl("CaseActivityIDField");
            string id = hiddenID.Value;

            int resultId;
            if (int.TryParse(id, out resultId))
            {
                if (e.CommandName.Equals("Create"))
                {
                    VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, resultId);
                    activity.FOLLOWUP_REQUIRED_FLAG = false;
                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.SaveFromReferral(CurrentUser, CurrentRegistryId, activity);

                    int swctId = 0;
                    VIRP.CRS.BO.STD_WKFCASETYPE swct = VIRP.CRS.BLL.STD_WKFCASETYPEManager.GetItemByCode(CurrentUser, CurrentRegistryId, "BIOLOGICAL MONITORING");

                    if (swct != null)
                        swctId = swct.ID;
                    else
                        swctId = 12; // should be 12, but shouldn't need

                    VIRP.CRS.BO.WKF_CASE wfCase = SetupWorkflowCase(swctId); // new VIRP.CRS.BO.WKF_CASE();

                    //clear previous reasons if any present 
                    rc.Referral.COMMENT_TEXT = null;

                    //VS - need to re-open referral if it's already closed 
                    if (rc.Referral.STD_REFERRALSTS_ID != rc.SrsEfrOpenCasesId)
                        rc.Referral.STD_REFERRALSTS_ID = rc.SrsEfrOpenCasesId;

                    //now add newly generated workflow to it's base referral. 
                    rc.WorkflowCaseList.Add(wfCase);
                }
                else if (e.CommandName.Equals("Decline"))
                {
                    VIRP.CRS.BO.WKF_CASE_ACTIVITY activity = VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.GetItem(CurrentUser, CurrentRegistryId, resultId);

                    activity.FOLLOWUP_DECLINED_DATE = DateTime.Today;
                    activity.FOLLOWUP_REQUIRED_FLAG = false;

                    VIRP.CRS.BLL.WKF_CASE_ACTIVITYManager.SaveFromReferral(CurrentUser, CurrentRegistryId, activity);
                }

                SaveReferral();

                GetRefreshReferral(rc.Referral.REFERRAL_ID);

                //re-load referral since we just saved it
                ShowReferralFromEntity();

                BioFollowUpsRepeater.DataBind();

                //refresh workflows gridview
                Workflows.DataBind();
            }
        }

        protected void Workflows_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            string[] arr = { "ADD", "EMPTYADD" };
            if (arr.Contains(e.CommandName))
            {
                int wkfcasetypeId = 0;

                gridViewSelectField.Value = "1";

                switch (e.CommandName)
                {
                    case "ADD":

                        DropDownList ddlWFTypes = Workflows.FooterRow.FindControl("WorkflowTypesList") as DropDownList;

                        int caseTypeOne;
                        if (ddlWFTypes != null)
                        {
                            if (int.TryParse(ddlWFTypes.SelectedValue, out caseTypeOne))
                            {
                                wkfcasetypeId = caseTypeOne;
                            }
                        }
                        break;

                    case "EMPTYADD":

                        DropDownList ddlWFEmptyTypes =
                            Workflows.Controls[0].Controls[0].FindControl("WorkflowTypesEmptyList") as DropDownList;

                        int caseType;
                        if (ddlWFEmptyTypes != null)
                        {
                            if (int.TryParse(ddlWFEmptyTypes.SelectedValue, out caseType))
                            {
                                wkfcasetypeId = caseType;
                            }
                        }
                        break;
                }

                VIRP.CRS.BO.WKF_CASE wfCase = SetupWorkflowCase(wkfcasetypeId);
               
                //now add newly generated workflow to it's base referral 
                rc.WorkflowCaseList.Add(wfCase);
                
                if (rc.Referral.STD_REFERRALSTS_ID != rc.SrsEfrOpenCasesId) 
                    rc.Referral.STD_REFERRALSTS_ID = rc.SrsEfrOpenCasesId;

                //Save the referral
                SaveReferral();

                SuppressSaveSuccessMessage = true;
                
                //re-load referral since we just saved it
                ShowReferralFromEntity();
                ReBindChangedData();
            }
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;

                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to: - Referrals page: " + ex.ToString(), string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), CurrentUser, CurrentRegistryId);
            }
        }

        private VIRP.CRS.BO.WKF_CASE SetupWorkflowCase(int std_wkfcasetype_id)
        {
            VIRP.CRS.BO.WKF_CASE wfCase = new VIRP.CRS.BO.WKF_CASE();

            wfCase.REFERRAL_ID = rc.Referral.REFERRAL_ID;
            wfCase.PATIENT_ID = rc.Patient.PATIENT_ID;
            wfCase.CASE_START_DATE = DateTime.Today;
            wfCase.CREATEDBY = CurrentUser;
            wfCase.UPDATEDBY = CurrentUser;
            wfCase.CASE_NUMBER = String.Empty;
            wfCase.CREATED = wfCase.UPDATED = DateTime.Today;
            wfCase.STD_WKFCASESTS_ID = rc.WcsEfrInProcess; 
            wfCase.STD_WKFCASETYPE_ID = std_wkfcasetype_id;

            return wfCase;
        }

        private enum WorkflowCaseStatus : int
        {
            New = 1,
            InProcess = 2,
            Completed = 5, 
            Canceled = 4
        }
    }
}